%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Work in the field of a point charge


clear all;
close all;

EPS0 = 8.8542*10^(-12);
Q1 = 10 * 10^(-9);
Q2 = -1 * 10^(-9);
a = 10*10^(-2);

% work
da = 0.000001 * a;
x0 = 0;
y0 = 0;
x1 = 0:da:a/2;
y1 = a/2 * ones(1,length(x1));
y2 = a/2: -da : -a/2;
x2 = a/2 * ones(1,length(y2));
x = [x1 x2];
y = [y1 y2];
r = sqrt((x-x0).^2 + (y-y0).^2);
F = [(x-x0)./r.^3 ; (y-y0)./r.^3]*(Q1*Q2/(4*pi*EPS0));
N =length(x);
dx = x  - [-da x(1:N-1)];
dy = y  - [a/2-da y(1:N-1)];
dl = [dx ; dy];
W = LineIntegral(F,dl);
% Output
fprintf('\nTotal work of electric force is: %2.3f nJ',W*10^9);


